% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Olink_color.R
\name{olink_pal}
\alias{olink_pal}
\title{Olink color panel for plotting}
\usage{
olink_pal(alpha = 1, coloroption = NULL)
}
\arguments{
\item{alpha}{transparency (optional)}

\item{coloroption}{string, one or more of the following:
c('red', 'orange', 'yellow', 'green', 'teal', 'turqoise', 'lightblue', 'darkblue', 'purple', 'pink')}
}
\value{
A character vector of palette hex codes for colors
}
\description{
Olink color panel for plotting
}
\examples{

library(scales)

#Color matrices
show_col(olink_pal()(10), labels = FALSE)
show_col(olink_pal(coloroption = c('lightblue', 'green'))(2), labels = FALSE)

#Contour plot
filled.contour(volcano, color.palette = olink_pal(), asp = 1)
filled.contour(volcano, color.palette = hue_pal(), asp = 1)


}
\keyword{Olink}
\keyword{color}
\keyword{palette}
