% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{ACEDuncanPolyK}
\alias{ACEDuncanPolyK}
\title{A function to compute Duncan's Constrained Absolute Centralisation Index}
\usage{
ACEDuncanPolyK(x, dc = NULL,  K = NULL, kdist = NULL, center = 1,
                spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group.}

\item{dc}{- a numeric matrix/vector containing the distances between spatial units
centroids and the central spatial unit(s).}

\item{K}{- the number of neighbourhoods under the influence of a center}

\item{kdist}{- the maximal distance that defines the neighbourhoods influenced
by a center}

\item{center}{- a numeric vector  giving the number of the spatial units that 
represent the centers in the table}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame) with 
geographic information}

\item{folder}{- a character vector with the folder (directory) 
name indicating where the shapefile is located on the drive}

\item{shape}{- a character vector with the name of the shapefile 
(without the .shp extension).}
}
\value{
a matrix containing relative centralisation index values
}
\description{
Constrained (local) version of Duncan's centralization index.
The function can be used in two ways: to provide a matrix containing 
the distances between spatial/organizational unit centroids or a external geographic 
information source (spatial object or shape file).
}
\examples{
x <- segdata@data[ ,1:2]
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'segdata'

ACEDuncanPolyK(x, spatobj = segdata, center = c(28, 83))

ACEDuncanPolyK(x, folder = foldername, shape = shapename, center = c(28, 83), K = 3)

center <- c(28, 83)
polydist <- matrix(data = NA, nrow = nrow(x), ncol = length(center))
for (i in 1:ncol(polydist))
  polydist[,i] <- distcenter(spatobj = segdata, center = center[i])
ACEDuncanPolyK(x, dc = polydist, kdist = 2)

}
\references{
Duncan O. D. and Duncan B. (1955) \emph{A 
Methodological Analysis of Segregation Indexes}. 
American Sociological Review 41, pp. 210-217

Folch D.C and Rey S. J (2016) \emph{The centralization index: 
A measure of local spatial segregation}. Papers in Regional 
Science 95 (3), pp. 555-576
}
\seealso{
\code{\link{ACEDuncan}}, \code{\link{ACEDuncanPoly}},

\code{\link{RCE}}, \code{\link{RCEPoly}}, \code{\link{RCEPolyK}}

\code{\link{ACE}}, \code{\link{ACEPoly}}
}
