
#' Households distribution by  size in Grenoble urban area in 2011
#' 
#' This data set gives the households distribution by size in 
#' Grenoble urban area in 2011, including the area vectorial map at
#' municipality level.
#' 
#' \itemize{
#'   \item code: Municipality code
#'   \item name: Municipality name
#'   \item small: (1-2 persons household)
#'   \item medium: (3-4 persons household)
#'   \item big: (more then 5 persons household)
#' }
#' 
#' @docType data
#' @keywords datasets
#' @source Insee: Resultats du recensement de la population 2011, \href{http://www.insee.fr/}{Insee}
#' @name GreHSize
#' @usage data(GreHSize)
#' @format A Spatial object including 52 polygons corresponding to each municipality of Grenoble Urban Area (Insee definition) and following data attributes: 
"GreHSize" 



#' Households distribution by age in Annecy urban area in 2011
#' 
#' This data set gives the households distribution by age in 
#' Annecy urban area in 2011, including the area vectorial map at
#' municipality level.
#' 
#' \itemize{
#'   \item code: Municipality code
#'   \item name: Municipality name
#'   \item young: 15-29 years old
#'   \item adult: 30-59 years old
#'   \item old: 60 years or more
#' }
#' 
#' @docType data
#' @keywords datasets
#' @source Insee: Resultats du recensement de la population 2011, \href{http://www.insee.fr/}{Insee}
#' @name AnnHAge
#' @usage data(AnnHAge)
#' @format A Spatial object including 19 polygons corresponding to each municipality of Grenoble Urban Area (Insee definition) and following data attributes: 
"AnnHAge" 
