% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReguCovar.R
\name{ReguCovar}
\alias{ReguCovar}
\title{Generate samples by ESPO and ADASYN.}
\usage{
ReguCovar(cleanData, targetClass, ratio, r, per, k, m, parallel, progBar)
}
\arguments{
\item{cleanData}{First column stores the label data. The other columns store the sample data (without NA, NaN values)}

\item{targetClass}{The class to be oversampled}

\item{ratio}{The oversampling ratio 
number (>=1) (default = 1)}

\item{r}{A scalar ratio specifying which level (towards the boundary) we shall 
push the synthetic data (in ESPO, default = 1)}

\item{per}{Ratio of weighting between ESPO and ADASYN (default = 0.8)}

\item{k}{Number of nearest neighbours in k-NN (for ADASYN) algorithm (default = 5)}

\item{m}{Seeds from the positive class in m-NN (for ADASYN) algorithm (default = 15)}

\item{parallel}{Whether to execute in parallel mode (default = TRUE). 
(Recommended for datasets with over 30,000 records.)}

\item{progBar}{Whether to include progress bars (default = TRUE).
For ESPO approach, the bar charactor is |--------|100\%. 
For ADASYN approach, the bar charactor is |========|100\%.}
}
\value{
newData
}
\description{
Generate samples by ESPO and ADASYN.
}
\keyword{internal}
