% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaleBar.R
\name{scaleBar}
\alias{scaleBar}
\title{scalebar for OSM plots}
\usage{
scaleBar(map, x = 0.1, y = 0.9, length = 0.4, abslen = NA,
  unit = c("km", "m", "mi", "ft", "yd"), label = unit, type = c("bar",
  "line"), ndiv = NA, field = "rect", fill = NA, adj = c(0.5, 1.5),
  cex = par("cex"), col = c("black", "white"), targs = NULL, lwd = 7,
  lend = 1, bg = "transparent", mar = c(2, 0.7, 0.2, 3), ...)
}
\arguments{
\item{map}{Map object with map$tiles[[1]]$projection to get the projection from.}

\item{x, y}{Relative position of left end of scalebar. DEFAULT: 0.1, 0.9}

\item{length}{Approximate relative length of bar. DEFAULT: 0.4}

\item{abslen}{Absolute length in \code{unit}s. DEFAULT: NA (computed internally from \code{length})}

\item{unit}{Unit for computation and label.
Possible: kilometer, meter, miles, feet, yards. DEFAULT: "km"}

\item{label}{Unit label in plot. DEFAULT: \code{unit}}

\item{type}{Scalebar type: simple \code{'line'} or classical black & white \code{'bar'}. DEFAULT: "bar"}

\item{ndiv}{Number of divisions if \code{type="bar"}. DEFAULT: NA (computed internally)
Internal selection of \code{ndiv} is based on divisibility of abslen
(modulo) with 1:6. For ties, preferation order is 5>4>3>2>6>1.}

\item{field, fill, adj, cex}{Arguments passed to \code{\link[berryFunctions]{textField}}}

\item{col}{Vector of (possibly alternating) colors passed to
\code{\link{segments}} or \code{\link{rect}}. DEFAULT: c("black","white")}

\item{targs}{List of further arguments passed to \code{\link[berryFunctions]{textField}}
like font, col (to differ from bar color), etc. DEFAULT: NULL}

\item{lwd, lend}{Line width and end style passed to \code{\link{segments}}.
DEFAULT: 5,1, which works well in pdf graphics.}

\item{bg}{Background color, e.g. \code{\link[berryFunctions]{addAlpha}(White)}.
DEFAULT: \code{"transparent"} to suppress background.}

\item{mar}{Background margins approximately in letter width/height. DEFAULT: c(2,0.7,0.2,3)}

\item{\dots}{Further arguments passed to \code{\link{segments}} like lty.
(Color for segments is the first value of \code{col}).
Passed to \code{\link{rect}} if \code{type="bar"}, like lwd.}
}
\value{
invisible: coordinates of scalebar and label
}
\description{
Add a scalebar to default or (UTM)-projected OpenStreetMap plots
}
\details{
scaleBar gets the right distance in the default mercator projected maps.
There, the axes are not in meters, but rather ca 0.7m units (for NW Germany area maps with 20km across).
Accordingly, other packages plot wrong bars, see the last example section.
}
\examples{
if(interactive()){
d <- data.frame(long=c(12.95, 12.98, 13.22, 13.11), lat=c(52.40,52.52, 52.36, 52.45))
map <- pointsMap(lat,long,d, scale=FALSE, zoom=9)
coord <- scaleBar(map)  ; coord
scaleBar(map, bg=berryFunctions::addAlpha("white", 0.7))
scaleBar(map, 0.3, 0.05, unit="m", length=0.45, type="line")
scaleBar(map, 0.3, 0.5, unit="km", abslen=5, col=4:5, lwd=3)
scaleBar(map, 0.3, 0.8, unit="mi", col="red", targ=list(col="blue", font=2), type="line")

# I don't like subdivisions, but if you wanted them, you could use:
scaleBar(map, 0.12, 0.28, abslen=10, adj=c(0.5, -1.5)  )
scaleBar(map, 0.12, 0.28, abslen=4, adj=c(0.5, -1.5), targs=list(col="transparent"), label="" )
}

\dontrun{ # don't download too many maps in R CMD check
d <- read.table(header=TRUE, sep=",", text="
lat, long
52.514687,  13.350012   # Berlin
51.503162,  -0.131082   # London
35.685024, 139.753365") # Tokio
map <- pointsMap(lat, long, d, zoom=2, abslen=5000, y=0.7)
scaleBar(map, y=0.5, abslen=5000)   # in mercator projections, scale bars are not
scaleBar(map, y=0.3, abslen=5000)   # transferable to other latitudes

map_utm <- pointsMap(lat, long, d[1:2,], proj=putm(long=d$long[1:2]),
                     zoom=4, y=0.7, abslen=500)
scaleBar(map_utm, y=0.5, abslen=500) # transferable in UTM projection
scaleBar(map_utm, y=0.3, abslen=500)
}

\dontrun{ ## Too much downloading time, too error-prone
# Tests around the world
par(mfrow=c(1,2), mar=rep(1,4))
long <- runif(2, -180, 180) ;  lat <- runif(2, -90, 90)
long <- 0:50 ;  lat <- 0:50
map <- pointsMap(lat, long)
map2 <- pointsMap(lat, long, map=map, proj=putm(long=long))
}

\dontrun{ ## excluded from tests to avoid package dependencies
berryFunctions::require2("SDMTools")
berryFunctions::require2("raster")
berryFunctions::require2("mapmisc")
par(mar=c(0,0,0,0))
map <- OSMscale::pointsMap(long=c(12.95, 13.22), lat=c(52.52, 52.36))
SDMTools::Scalebar(x=1443391,y=6889679,distance=10000)
raster::scalebar(d=10000, xy=c(1443391,6884254))
OSMscale::scaleBar(map, x=0.35, y=0.45, abslen=5)
library(mapmisc) # otherwise rbind for SpatialPoints is not found
mapmisc::scaleBar(map$tiles[[1]]$projection, seg.len=10, pos="center", bg="transparent")
}

}
\seealso{
\code{\link{pointsMap}}, \code{\link{projectPoints}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jun 2016
}
\keyword{aplot}
\keyword{spatial}
