% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORdensity.R
\name{summary.ORdensity}
\alias{summary.ORdensity}
\title{Summary function implemented by ORdensity class}
\usage{
\method{summary}{ORdensity}(object, numclusters = NULL, ...)
}
\arguments{
\item{object}{An object of \code{\link{ORdensity}} class.}

\item{numclusters}{By default \code{NULL}, it inherits from the ORdensity \code{object}. 
Optionally, an integer number indicating number of clusters.}

\item{...}{Optional arguments inherited from the generic \code{\link{summary}} method.}
}
\value{
A list with \eqn{k} lists where \eqn{k} is the best number of clusters found. 
The clusters are ordered based on their importance according to the mean OR values of the clusters 
(greater is the mean OR value of the cluster more important are the genes in the cluster).
The first one is the most important, the last one the less important. Each list has elements:
\itemize{
\item \code{numberOfGenes}: Number of genes in the cluster.
\item \code{CharacteristicsCluster}: Matrix with mean values and standard deviation of variables OR, FP and dFP for each cluster.
\item \code{Genes}: Identification of the genes in the cluster.
}
}
\description{
This function clusters the potential differentially expressed (DE) genes among them 
so that the real DE genes can be distinguish from the not DE genes.
}
\details{
Once the potential DE genes are identified, the real DE genes and the not real DE genes or
false positives must be distinguished. Since the real DE genes must have high OR values along with
low FP and dFP values, and on the contrary, the false DE genes must have low OR values but high FP and dFP values,
a clustering of all the potential DE genes is carried out. The clustering is based on build-on variables OR, FP and dFP 
(see class \code{ORdensity}) which are scaled. The clustering algorithm is   \code{\link{pam}} and by default
the number of clusters in the partition is obtained by \code{\link{silhouette}}. With parameter \code{numclusters} the number
of clusters in the partition can be customized.
}
\examples{
# Read data from 2 experimental conditions
simexpr_reduced <- simexpr[c(1:15,101:235),]
x <- simexpr_reduced[, 3:32]
y <- simexpr_reduced[, 33:62]
EXC.1 <- as.matrix(x)
EXC.2 <- as.matrix(y)
myORdensity <- new("ORdensity", Exp_cond_1 = EXC.1, Exp_cond_2 = EXC.2, B = 20)
summary(myORdensity)
}
