% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{anova.opsr}
\alias{anova.opsr}
\title{ANOVA for OPSR Model Fits}
\usage{
\method{anova}{opsr}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"opsr"}.}

\item{...}{additional objects of class \code{"opsr"}. See also the 'Details' section.}
}
\value{
An object of class \code{"anova.opsr"}.
}
\description{
Conducts likelihood ratio tests for one or more OPSR model fits.
}
\details{
If only a single object is passed then the model is compared to the null model
(\code{\link{opsr_null_model}}). If more than one object is specified, a likelihood ratio
test is conducted for each pair of neighboring models. It is conventional to
list the models from smallest to largest, but this is up to the user.
}
\examples{
sim_dat <- opsr_simulate()
dat <- sim_dat$data
model <- ys | yo ~ xs1 + xs2 | xo1 + xo2
fit <- opsr(model, dat)
fit_null <- opsr_null_model(fit)
fit_intercept <- update(fit, ~ . | 1)

anova(fit)
anova(fit_null, fit_intercept, fit)
}
\seealso{
\code{\link[stats:anova]{stats::anova}}, \code{\link{print.anova.opsr}}
}
