% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{search_dataset}
\alias{search_dataset}
\title{Search codes and descriptions of available OECD series}
\usage{
search_dataset(string, data = get_datasets(), ignore.case = TRUE)
}
\arguments{
\item{string}{A regular expression string to search for.}

\item{data}{The data frame to search. This can be either a data frame 
previously fetched using \code{\link{get_datasets}} (recommended) or left 
blank, in which case a temporary data frame is fetched. The second option 
adds a few seconds to each search query.}

\item{ignore.case}{Whether the search should be case-insensitive.}
}
\value{
A data frame.
}
\description{
Returns a data frame containing the series codes and descriptions for the 
OECD series which match the given criteria.
}
\examples{
\dontrun{dsets <- get_datasets()}
\dontrun{search_dataset("employment", dsets)}

}
\seealso{
\code{\link{get_datasets}}
}
