% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlphaSensCurve.R
\name{AlphaSensCurve}
\alias{AlphaSensCurve}
\title{Sensitivity alpha-curve associated to MLP function of an input variable}
\usage{
AlphaSensCurve(sens, tol = NULL, max_alpha = 100)
}
\arguments{
\item{sens}{raw sensitivities of the MLP output with respect to input variable.}

\item{tol}{difference between M_alpha and maximum sensitivity of the sensitivity of each input variable}

\item{max_alpha}{maximum alpha value to analyze}
}
\value{
alpha-curve of the MLP function
}
\description{
Obtain sensitivity alpha-curve associated to MLP function obtained from
the sensitivities returned by \code{\link[NeuralSens]{SensAnalysisMLP}} of an input variable.
}
\examples{
\donttest{
mod <- RSNNS::mlp(simdata[, c("X1", "X2", "X3")], simdata[, "Y"],
                 maxit = 1000, size = 15, linOut = TRUE)

sens <- SensAnalysisMLP(mod, trData = simdata,
                        output_name = "Y", plot = FALSE)

AlphaSensCurve(sens$raw_sens[[1]][,1])
}
}
