% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.redundant.R
\name{node.redundant}
\alias{node.redundant}
\title{Detects Redundant Nodes in a Network}
\usage{
node.redundant(A, sig, method = c("alpha", "bonferroni", "FDR", "adapt"))
}
\arguments{
\item{A}{Matrix or data frame.
An adjacency matrix of network data}

\item{sig}{Numeric.
\emph{p}-value for significance of overlap (defaults to \code{.05}).
If more than 200 connections, then \code{\link[fdrtool]{fdrtool}}
is used to correct for false positives. In these instances, \code{sig}
sets the \emph{q}-value for significance of overlap (defaults to \code{.10})}

\item{method}{Character.
Computes significance using the standard \emph{p}-value (\code{"alpha"}),
bonferonni corrected \emph{p}-value (\code{"bonferroni"}),
false-discovery rate corrected \emph{p}-value (\code{"FDR"}),
or adaptive alpha \emph{p}-value (\code{\link[NetworkToolbox]{adapt.a}}).
Defaults to \code{"alpha"}}
}
\value{
Returns a list with vectors nested within the list corresponding
to redundant nodes with the name of object in the list
}
\description{
Identifies redundant nodes in the network based on several
measures. Computes the weighted topological overlap between
each node and every other node in the network. The weighted topological
overlap is implemented using the method from Nowick et al. (2009; see references)
and the function \link[wTO]{wTO} from the wTO package.
}
\examples{

net <- TMFG(neoOpen, normal = FALSE)$A

result <- node.redundant(A = net, method = "adapt")

}
\references{
#wTO
Nowick, K., Gernat, T., Almaas, E., & Stubbs, L. (2009).
Differences in human and chimpanzee gene expression patterns define an evolving network of transcription factors in brain.
\emph{Proceedings of the National Academy of Sciences}, \emph{106}, 22358-22363.
doi: \href{https://doi.org/10.1073/pnas.0911376106}{10.1073/pnas.0911376106}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
