% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{comcat}
\alias{comcat}
\title{Communicating Nodes}
\usage{
comcat(A, factors = c("walktrap", "louvain"), cent = c("strength",
  "degree"), ...)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{factors}{Can be a vector of factor assignments or community detection algorithms
("walktrap" or "louvain") can be used to determine the number of factors.
Defaults to "walktrap".
Set to "louvain" for louvain community detection}

\item{cent}{Centrality measure to be used.
Defaults to "strength".}

\item{...}{Additional arguments for community detection algorithms}
}
\value{
A matrix containing the between-community strength value for each node
}
\description{
Computes the between-community strength for each node in the network
}
\examples{
A<-TMFG(neoOpen)$A

communicating <- comcat(A, factors = "walktrap")
}
\references{
Blanken, T. F., Deserno, M. K., Dalege, J., Borsboom, D., Blanken, P., Kerkhof, G. A., & Cramer, A. O. (2018).
The role of stabilizing and communicating symptoms given overlapping communities in psychopathology networks.
\emph{Scientific Reports}, \emph{8}(1), 5854.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
