% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{Eigenvector}
\alias{Eigenvector}
\title{Eigenvector Centrality}
\usage{
Eigenvector(A, weighted = TRUE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted? Defaults to TRUE. Set to FALSE for unweighted measure of eigenvector centrality}
}
\value{
A vector of eigenvector centrality values for each node in the network
}
\description{
Computes eigenvector centrality of each node in a network
}
\examples{
weighted_EC<-Eigenvector(A)

unweighted_EC<-Eigenvector(A,weighted=FALSE)
}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
Neuroimage, 52(3), 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
