% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communicability_measures.R
\name{criticality}
\alias{criticality}
\title{Criticality of the vertices}
\usage{
criticality(exposures, buffer, binary = FALSE, exposure_type = c("assets",
  "liabilities", "impact", "vulnerability"))
}
\arguments{
\item{exposures}{an adjacency \code{\link{matrix}}, (sparse) \code{\link{Matrix}} or an \code{\link[igraph]{igraph}}
object with the network of bilateral exposures between vertices. By default, the function
expects the exposures in the form of an assets matrix
in which A -> B means that A has an asset with B. However, you can
change that with the parameter \code{exposure_type}. When using a matrix, preferably it should have
rows and columns names.}

\item{buffer}{a numeric vector with the capital buffer for each vertex.
Values should be in the same row/column order as the network of bilateral exposures. The
buffer is not needed if \code{exposure_type = "vulnerability"}.}

\item{binary}{if \code{binary = TRUE} the function computes a 'binary' impact or vulnerability matrix.
It truncates all values less than 1 to 0 and all values greater than 1 to 1.}

\item{exposure_type}{character vector indicating the type of the bilateral exposures. It can be
an \code{"assets"} network (where A -> B means that A has an asset with B),
a \code{"liabilities"} network (where A -> B means that A has a debt with B),
a (binary) \code{"impact"} matrix (where A -> B indicates the relative impact
 of A in B's capital buffer), or 
a (binary) \code{"vulnerability"} matrix 
(where A -> B indicates the relative impact A suffers from B's default). 
The default is \code{"assets"}.}
}
\value{
The function returns a (named) vector with the criticality for each vertex.
}
\description{
The criticality of a vertex measures its impact
on its neighbors if it defaults.  It is basically the \code{\link{rowSums}}
of the \code{\link{impact_matrix}}.
}
\examples{
# Creating example data
## Assets Matrix (bilateral exposures)
assets_matrix <- matrix(c(0, 10, 3, 1, 0, 2, 0, 3, 0), ncol = 3)
rownames(assets_matrix) <- colnames(assets_matrix) <- letters[1:3]

## Capital Buffer
buffer <- c(a = 2, b = 5, c = 2)

# Criticality
criticality(assets_matrix, buffer)

}

