% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cascade.R
\name{subset_cascade_time}
\alias{subset_cascade_time}
\title{Subset a cascade object in time}
\usage{
subset_cascade_time(cascade, start_time, end_time, drop = TRUE)
}
\arguments{
\item{cascade}{cascade, object to subset.}

\item{start_time}{numeric, start time of the subset.}

\item{end_time}{numeric, end time of the subset.}

\item{drop}{logical, should empty sub-cascades be dropped?}
}
\value{
An object of class cascade, where only events are included that have 
    times \code{start_time} <= t < \code{end_time}.
}
\description{
Remove each all events occuring outside the desired subset for each cascade 
in a cascade object.
}
\examples{

data(cascades)
sub_cascades <- subset_cascade_time(cascades, 10, 20, drop=TRUE)

}
