% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SlicecdGammaPareto.R
\name{ILFSlicedGammaPareto}
\alias{ILFSlicedGammaPareto}
\title{Increased Limit Factor Curve from a Sliced Gamma Pareto severity distribution}
\usage{
ILFSlicedGammaPareto(xLow, xHigh, GShape, GRate, SlicePoint, PShape)
}
\arguments{
\item{xLow}{A positive real number -  the claim amount where the Limit Factor Curve will be evaluated from.}

\item{xHigh}{A positive real number -  the claim amount where the Limit Factor Curve will be evaluated to.}

\item{GShape}{A positive real number -  the shape parameter of the attritional Claim Severity's Gamma distribution.}

\item{GRate}{A positive real number -  the rate parameter of the attritional Claim Severity's Gamma distribution.}

\item{SlicePoint}{A positive real number - the slice point and the scale parameter of the tail Claim Severity's Pareto distribution.}

\item{PShape}{A positive real number - the shape parameter of the tail Claim Severity's Pareto distribution.}
}
\value{
The value of the Increased Limit Factor curve from \code{xLow} to \code{xHigh} with an attritional claim Gamma distribution with parameters \code{GShape} and \code{GRate} and a large claim Pareto distribution with parameters \code{SlicePoint} and \code{PShape}.
}
\description{
Increased Limit Factor Curve from a Sliced Gamma Pareto severity distribution
}
\examples{
ILFSlicedGammaPareto(2000,3000,1,0.0005,1000,1.2)
ILFSlicedGammaPareto(800,1000,1.1,0.0006,2000,1.6)
ILFSlicedGammaPareto(1200,2000,1.2,0.0004,3000,1.4)
}
