% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patch-functions.R
\docType{methods}
\name{patches}
\alias{patches}
\alias{patches,worldNLR-method}
\title{All the patches in a world}
\usage{
patches(world)

\S4method{patches}{worldNLR}(world)
}
\arguments{
\item{world}{WorldMatrix or worldArray object.}
}
\value{
Matrix (ncol = 2) with the first column "pxcor" and the second column
        "pycor" representing the patches coordinates. The order of the patches
        follows the order of the cells numbers as defined for a Raster* object.
}
\description{
Report the coordinates of all the patches in the \code{world}.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
allPatches <- patches(world = w1)
NLcount(allPatches) # 100 patches

}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#patches}
}
\author{
Sarah Bauduin
}
