% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\name{createOTurtles}
\alias{createOTurtles}
\alias{createOTurtles,numeric-method}
\title{Create ordered \code{turtles}}
\usage{
createOTurtles(n, world, breed, color)

\S4method{createOTurtles}{numeric}(n, world, breed, color)
}
\arguments{
\item{n}{Integer.}

\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{breed}{Character. Vector of \code{breed} names. Must be of length 1 or of length
\code{n}. If missing, \code{breed = "turtle"} for all \code{turtles}.}

\item{color}{Character. Vector of \code{color} names. Must be of length \code{n}.
If missing, \code{colors} are assigned using the function \code{rainbow(n)}.}
}
\value{
\code{AgentMatrix} object of length \code{n} with data for the
        turtles being: \code{xcor}, \code{ycor}, \code{who}, \code{heading}, \code{prevX}, \code{prevY}, \code{breed},
        and \code{color}.
}
\description{
Create \code{n} \code{turtles} at the center of the \code{world} with their \code{headings} evenly
distributed.
}
\details{
The identity of the \code{turtles} is defined by their \code{who} number. This
         numbering starts at 0 and increments by 1.

         The coordinates from the previous time step are stored in \code{prevX} and
         \code{prevY}. The initial values are \code{NA}.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4,
                          data = runif(25))
t1 <- createOTurtles(n = 10, world = w1)
plot(w1)
points(t1, col = of(agents = t1, var = "color"), pch = 16)

t1 <- fd(turtles = t1, dist = 1)
points(t1, col = of(agents = t1, var = "color"), pch = 16)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#create-ordered-turtles}
}
\author{
Sarah Bauduin and Eliot McIntire
}
