% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_netfacs.R
\name{prepare.netfacs}
\alias{prepare.netfacs}
\title{Take data that are not currently in format and turn them into the correct format for netfacs function}
\usage{
prepare.netfacs(
  elements,
  type = c("video", "photo"),
  video.id = NULL,
  start.time = NULL,
  duration = NULL,
  separator = ",",
  frame.duration = NULL
)
}
\arguments{
\item{elements}{vector with either one element per index (for videos) or all elements that occurred in the whole event (for photos)}

\item{type}{either 'video' or 'photo'. If 'photo', the function separates the string and returns a matrix of the correct dimensions. If 'video', the function creates a matrix using the highest common factor of all 'durations' and for each of those 'frames' assigns whether each element was present or absent}

\item{video.id}{name of the video, so all cases are treated together. For photos, can be entered so that photos can be matched to IDs after}

\item{start.time}{for videos, time when the element is first active}

\item{duration}{for videos, how long is the element active for}

\item{separator}{for photos, how are elements separated in the list}

\item{frame.duration}{for videos, how long is a 'frame' supposed to last? If NULL, frame duration is the shortest 'duration' of any element specified}
}
\value{
Function returns a list with element.matrix (the matrix of elements and when they occurred) and video.info (the supporting information, e.g. video names, durations, frames etc)
}
\description{
The \code{\link{netfacs}} function requires data to be entered with the element data as a matrix of each element by each event,
with occurrence marked as 1 and non-occurrence marked as 0.\cr
This is often not the case, so this function transforms data in other routine formats to have the right look.\cr
Specifically, users can define whether they want to enter 'photos', which indicates that all elements in an event are simply strung together in a vector; or they define 'video', in which case it is assumed that each element has a start and an end point in a specified video
}
\details{
The assumption for this function is that for photos, elements are stored like this: \cr
'AU1/AU2/AU3/AU4'\cr
'AU1/AU3/AU4'\cr
'AU1/AU2'\cr
\cr
For videos, the assumption is that they are stored in a data frame like this: \cr
element = AU1, video.id = 1, start.time = 0.5, duration = 2sec
}
\examples{
# for a photo
au.photos <- c(
  "AU1/AU5/AU9",
  "AU1/AU2",
  "AU1/AU2/AU10",
  "AU1/AU2",
  "AU5/AU17/AU18",
  "AU6/AU12"
)
au.names <- c("photo1", "photo2", "photo3", "photo4", "photo5", "photo6")
au.prepared <- prepare.netfacs(
  elements = au.photos,
  type = "photo",
  video.id = au.names,
  separator = "/"
)
au.prepared$element.matrix
au.prepared$video.info

# for a video
aus <- c(
  "AU1", "AU5", "AU9",
  "AU1", "AU2",
  "AU1", "AU2", "AU10",
  "AU1", "AU2",
  "AU5", "AU17", "AU18",
  "AU6", "AU12"
)
video.names <- c(
  rep("video1", 3),
  rep("video2", 2),
  rep("video3", 3),
  rep("video4", 2),
  rep("video5", 3),
  rep("video6", 2)
)
start.times <- c(
  0.1, 0.2, 0.3,
  0.1, 0.3,
  0.1, 0.4, 0.4,
  0.1, 0.2,
  0.1, 0.5, 0.6,
  0.1, 0.2
)
durations <- rep(0.3, times = length(start.times))
frame.dur <- 0.05
au.prepared <- prepare.netfacs(
  elements = aus,
  type = "video",
  video.id = video.names,
  start.time = start.times,
  duration = durations,
  frame.duration = frame.dur
)
head(au.prepared$element.matrix)
head(au.prepared$video.info)
}
