\name{samplehouseholds_HHhead_at_group_level}
\alias{samplehouseholds_HHhead_at_group_level}
\title{
Rcpp implementation for sampling household data without constraints.
}
\description{
Rcpp implementation for sampling household data without constraints.
}
\usage{
samplehouseholds_HHhead_at_group_level(phi, omega, pi, d, lambda, currrentbatch,
                                        nHouseholds, householdsize)
}
\arguments{
  \item{phi}{Matrix of posterior samples for the individual-level probabilities for each individual-level variable by each pair of group-level and individual-level latent classes.}
  \item{omega}{Matrix of the probabilities for the individual-level latent classes by the group-level latent classes.}
  \item{pi}{Vector of the probabilities for the group-level latent classes.}
  \item{d}{Vector containing the number of levels for each of the indiviual-level variables.}
  \item{lambda}{A list of matrices of the group-level probabilities for each group-level variable by the group-level latent classes. Each matrix in the list is for each group-level variable.}
  \item{currrentbatch}{
  The current batch number for the household data to be generated. The household ID will be generated based on this batch number.
}
  \item{nHouseholds}{
  The number of households to be generated by one call to this function.
}
  \item{householdsize}{
  The size of the households to be generated.
}
}
\details{
 This function allows the model to generate a batch of \verb{nHouseholds} with each household of size \verb{householdsize}. The generated household data will include both possible and impossible households. Use \verb{samplehouseholds_HHhead_at_group_level} when the household head is moved to the household level.
}
\value{
A data matrix with each row for one household.
}

\author{
Quanli Wang
}
\keyword{sampler}
\keyword{household data without constraint}
