% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nasdaq_data_link_database.R
\name{NasdaqDataLink.database.bulk_download_to_file}
\alias{NasdaqDataLink.database.bulk_download_to_file}
\title{Downloads a zip with all data from a Nasdaq Data Link database}
\usage{
NasdaqDataLink.database.bulk_download_to_file(database_code, filename, ...)
}
\arguments{
\item{database_code}{Database code on Nasdaq Data Link specified as a string.}

\item{filename}{Filename (including path) of file to download.}

\item{...}{Additional named values that are interpreted as NasdaqDataLink API parameters. Please see \url{https://docs.data.nasdaq.com/docs/parameters-2} for a full list of parameters.}
}
\value{
The filename of the downloaded file.
}
\description{
Downloads a zip with all data from a Nasdaq Data Link database
}
\details{
Set your \code{api_key} with \code{NasdaqDataLink.api_key} function. For instructions on finding your api key go to \url{https://data.nasdaq.com/account/profile}
}
\examples{
\dontrun{
NasdaqDataLink.database.bulk_download_to_file("NSE", "./NSE.zip")
}
}
\seealso{
\code{\link{NasdaqDataLink.api_key}}
}
