% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{agri_studies}
\alias{agri_studies}
\title{Agribusiness studies survey}
\format{
A data frame with 53 rows (participants) and 42 columns (questions):
\itemize{
\item columns 1-38: statements about agribusiness studies
\item columns 39-42: personal information
}
}
\source{
Juliette LE COLLONNIER and Lou ROBERT, students at l'Institut Agro Rennes-Angers
}
\usage{
agri_studies
}
\description{
These data were collected after a Q-method-like survey on students' expectations of agribusiness studies.
Participants had to rank how much they agreed with 38 statements about possible benefits from agribusiness studies; then, they were asked personal questions.
}
\examples{
\donttest{
# Processing time is often longer than ten seconds
# because the function uses a large language model.

library(NaileR)
data(agri_studies)

res_mca_agri <- FactoMineR::MCA(agri_studies, quali.sup = 39:42,
level.ventil = 0.05, graph = FALSE)
agri_work <- res_mca_agri$ind$coord |> as.data.frame()
agri_work <- agri_work[,1] |> cbind(agri_studies)

intro_agri <- "These data were collected after a survey
on students' expectations of agribusiness studies.
Participants had to rank how much they agreed with 38 statements
about possible benefits from agribusiness studies;
then, they were asked personal questions."
intro_agri <- gsub('\n', ' ', intro_agri) |>
stringr::str_squish()

res_agri <- nail_condes(agri_work, num.var = 1,
introduction = intro_agri)
cat(res_agri$response)
}
}
\keyword{datasets}
