% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMC.r
\name{Sstep.Clutter}
\alias{Sstep.Clutter}
\title{Sequential Monte Carlo for A Moving Target under Clutter Environment}
\usage{
Sstep.Clutter(mm, xx, logww, yyy, par, xdim, ydim)
}
\arguments{
\item{mm}{the Monte Carlo sample size \code{m}.}

\item{xx}{the sample in the last iteration.}

\item{logww}{the log weight in the last iteration.}

\item{yyy}{the observations.}

\item{par}{a list of parameter values \code{(ssw,ssv,pd,nyy,yr)}, where \code{ssw} is the standard deviation in the state equation,
\code{ssv} is the standard deviation for the observation noise, \code{pd} is the probability to observe the true signal, \code{nyy} the dimension of the data,
and \code{yr} is the range of the data.}

\item{xdim}{the dimension of the state varible.}

\item{ydim}{the dimension of the observation.}
}
\value{
The function returns a list with the following components:
\item{xx}{the new sample.}
\item{logww}{the log weights.}
}
\description{
The function performs one step propagation using the sequential Monte Carlo method with partial state proposal for tracking in clutter problem.
}
\examples{
nobs <- 100; pd <- 0.95; ssw <- 0.1; ssv <- 0.5;
xx0 <- 0; ss0 <- 0.1; nyy <- 50;
yrange <- c(-80,80); xdim <- 2; ydim <- nyy;
simu <- simuTargetClutter(nobs,pd,ssw,ssv,xx0,ss0,nyy,yrange)
resample.sch <- rep(1,nobs)
mm <- 10000
yr <- yrange[2]-yrange[1]
par <- list(ssw=ssw,ssv=ssv,nyy=nyy,pd=pd,yr=yr)
yr<- yrange[2]-yrange[1]
xx.init <- matrix(nrow=2,ncol=mm)
xx.init[1,] <- yrange[1]+runif(mm)*yr
xx.init[2,] <- rep(0.1,mm)
out <- SMC(Sstep.Clutter,nobs,simu$yy,mm,par,xx.init,xdim,ydim,resample.sch)
}
\references{
Tsay, R. and Chen, R. (2018). Nonlinear Time Series Analysis. John Wiley & Sons, New Jersey.
}
