% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{g_cfar1}
\alias{g_cfar1}
\title{Generate a CFAR(1) Process}
\usage{
g_cfar1(tmax = 1001, rho = 5, phi_func = NULL, grid = 1000,
  sigma = 1, ini = 100)
}
\arguments{
\item{tmax}{length of time.}

\item{rho}{parameter for O-U process (noise process).}

\item{phi_func}{convolutional function. Default is density function of normal distribution with mean 0 and standard deviation 0.1.}

\item{grid}{the number of grid points used to construct the functional time series. Default is 1000.}

\item{sigma}{the standard deviation of O-U process. Default is 1.}

\item{ini}{the burn-in period.}
}
\value{
The function returns a list with components:
\item{cfar1}{a tmax-by-(grid+1) matrix following a CFAR(1) process.}
\item{epsilon}{the innovation at time tmax.}
}
\description{
Generate a convolutional functional autoregressive process with order 1.
}
\examples{
phi_func= function(x)
{
 	return(dnorm(x,mean=0,sd=0.1))
}
y=g_cfar1(1000,5,phi_func,grid=1000,sigma=1,ini=100)
}
\references{
Liu, X., Xiao, H., and Chen, R. (2016) Convolutional autoregressive models for functional time series. \emph{Journal of Econometrics}, 194, 263-282.
}
