% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NORMA.R
\name{ILF_cost_der}
\alias{ILF_cost_der}
\alias{beta_cost_der}
\alias{general_gaussian_cost_der}
\alias{general_laplace_cost_der}
\alias{moge_cost_der}
\alias{weibull_cost_der}
\alias{zero_gaussian_cost_der}
\alias{zero_laplace_cost_der}
\title{Cost Functions Derivatives}
\usage{
ILF_cost_der(phi, epsilon = 0.1, nu = 0)

zero_laplace_cost_der(phi, sigma)

general_laplace_cost_der(phi, sigma, mu)

zero_gaussian_cost_der(phi, sigma_cuad)

general_gaussian_cost_der(phi, sigma_cuad, mu)

beta_cost_der(phi, alpha, beta)

weibull_cost_der(phi, lambda, kappa)

moge_cost_der(phi, lambda, alpha, theta)
}
\arguments{
\item{phi}{point to use as argument of the loss function derivative.}

\item{epsilon}{width of the insensitive band.}

\item{nu}{parameter to control value of \code{epsilon}.}

\item{sigma}{scale parameter of the Laplace distribution.}

\item{mu}{location or mean parameter of the Laplace or Gaussian distribution, respectively.}

\item{sigma_cuad}{variance parameter of the Gaussian distribution.}

\item{alpha}{shape1 parameter of the Beta distribution or second parameter of the MOGE distribution.}

\item{beta}{shape2 parameter of the Beta distribution.}

\item{lambda}{lambda scale parameter of the Weibull distribution or first parameter of the MOGE distribution.}

\item{kappa}{shape parameter of the Weibull distribution.}

\item{theta}{third parameter of the MOGE distribution.}
}
\value{
Returns a \code{numeric} representing the derivative value at a given point.
}
\description{
\code{ILF_cost_der} computes the ILF derivative value at a given point.

\code{zero_laplace_cost_der} computes the value at a given point of the loss function derivative
corresponding to a zero-mean Laplace distribution.

\code{general_laplace_cost_der} computes the value at a given point of the loss function derivative
corresponding to a general Laplace distribution.

\code{zero_gaussian_cost_der} computes the value at a given point of the loss function derivative
corresponding to a zero-mean Gaussian distribution.

\code{general_gaussian_cost_der} computes the value at a given point of the loss function derivative
corresponding to a general Gaussian distribution.

\code{beta_cost_der} computes the value at a given point of the loss function derivative
corresponding to a Beta distribution.

\code{weibull_cost_der} computes the value at a given point of the loss function derivative
corresponding to a Weibull distribution.

\code{moge_cost_der} computes the value at a given point of the loss function derivative
corresponding to a MOGE distribution.
}
\details{
See also 'References'.
}
\examples{
# ILF derivative value at point phi=1 with default epsilon.
ILF_cost_der(1)

# ILF derivative value at point phi=1 with epsilon=2.
ILF_cost_der(1,2)

# Zero-mean Laplace loss function derivative value at point phi=1 with sigma=1.
zero_laplace_cost_der(1,1)

# General Laplace loss function derivative value at point phi=1 with mu=0 and sigma=1.
general_laplace_cost_der(1,1,0)

# Zero-mean Gaussian loss function derivative value at point phi=1 with sigma_cuad=1.
zero_gaussian_cost_der(1,1)

# General Gaussian loss function derivative value at point phi=1 with mu=0 and sigma_cuad=1.
general_gaussian_cost_der(1,1,0)

# Beta loss function derivative value at point phi=1 with alpha=2 and beta=3.
beta_cost_der(1,2,3)

# Weibull loss function derivative value at point phi=1 with lambda=2 and kappa=3.
weibull_cost_der(1,2,3)

# MOGE loss function derivative value at point phi=1 with lambda=2 ,alpha=3 and theta=4.
moge_cost_der(1,2,3,4)
}
\author{
Jesus Prada, \email{jesus.prada@estudiante.uam.es}
}
\references{
Link to the scientific paper

Prada, Jesus, and Jose Ramon Dorronsoro. "SVRs and Uncertainty Estimates in Wind 
Energy Prediction." Advances in Computational Intelligence. Springer International 
Publishing, 2015. 564-577,

with theoretical background for this package is provided below.

\url{http://link.springer.com/chapter/10.1007/978-3-319-19222-2_47}
}

