% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dependence.R
\name{NNS.dep}
\alias{NNS.dep}
\title{NNS Dependence}
\usage{
NNS.dep(x, y = NULL, order = NULL, degree = NULL,
  print.map = FALSE, ncores = NULL)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame.}

\item{y}{\code{NULL} (default) or a numeric vector with compatible dimsensions to \code{x}.}

\item{order}{integer; Controls the level of quadrant partitioning.  Defaults to \code{(order = NULL)}.  Errors can generally be rectified by setting \code{(order = 1)}.  Will not partition further if less than 4 observations exist in a quadrant.}

\item{degree}{integer; Defaults to NULL to allow number of observations to be \code{"degree"} determinant.}

\item{print.map}{logical; \code{FALSE} (default) Plots quadrant means.}

\item{ncores}{integer; value specifying the number of cores to be used in the parallelized  procedure. If NULL (default), the number of cores to be used is equal to the number of cores of the machine - 1.}
}
\value{
Returns the bi-variate \code{"Correlation"} and \code{"Dependence"} or correlation / dependence matrix for matrix input.
}
\description{
Returns the dependence and nonlinear correlation between two variables based on higher order partial moment matrices measured by frequency or area.
}
\examples{
set.seed(123)
x <- rnorm(100) ; y <- rnorm(100)
NNS.dep(x, y)

## Correlation / Dependence Matrix
x <- rnorm(100) ; y <- rnorm(100) ; z <- rnorm(100)
B <- cbind(x, y, z)
NNS.dep(B)
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\author{
Fred Viole, OVVO Financial Systems
}
