% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Normalization.R
\name{NNS.norm}
\alias{NNS.norm}
\title{NNS Normalization}
\usage{
NNS.norm(A, chart.type = NULL, Linear = F, order = NULL)
}
\arguments{
\item{A}{a numeric matrix or data frame.}

\item{chart.type}{{"l","b"}; \code{NULL} (default).  Set \code{(chart.type="l")} for line, \code{(chart.type="b")} for boxplot.}

\item{Linear}{logical; \code{FALSE} (default) Performs a linear scaling normalization, resulting in equal means for all variables.}

\item{order}{integer; \code{NULL} (default) Controls the \link{NNS.cor} \code{"order"} for number of partial moment quadrant partitions.}
}
\value{
Returns a \link{data.frame} of normalized values.
}
\description{
Normalizes a matrix of variables based on nonlinear scaling normalization method.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
A<-cbind(x,y)
NNS.norm(A)
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{normalization}

