% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partial_Moments.R
\name{D.UPM}
\alias{D.UPM}
\title{Divergent-Upper Partial Moment
(Upper Left Quadrant 2)}
\usage{
D.UPM(degree.x, degree.y, x, y, target.x = mean(x), target.y = mean(y))
}
\arguments{
\item{degree.x}{Degree for variable X.  \code{degree.x = 0} is frequency, \code{degree.x = 1} is area.}

\item{degree.y}{Degree for variable Y.  \code{degree.y = 0} is frequency, \code{degree.y = 1} is area.}

\item{x}{Variable X}

\item{y}{Variable Y}

\item{target.x}{Typically the mean of Variable X, but does not have to be.}

\item{target.y}{Typically the mean of Variable Y, but does not have to be.}
}
\value{
Divergent UPM of two variables
}
\description{
This function generates a multivariate divergent upper partial moment for any degree or target.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
D.UPM(0,0,x,y,mean(x),mean(y))
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{covariance}
\keyword{moments,}
\keyword{partial}

