% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dy_d_wrt.R
\name{dy.d_}
\alias{dy.d_}
\title{Partial Derivative dy/d[wrt]}
\usage{
dy.d_(B, y, wrt, eval.points = "median", order = NULL, s.t.n = 0.9,
  h = 0.1, n.best = 2, mixed = FALSE, plot = FALSE, precision = "LOW",
  norm = NULL, noise.reduction = NULL)
}
\arguments{
\item{B}{Complete dataset of regressors in matrix form.}

\item{y}{Dependent Variable}

\item{wrt}{Selects the regressor to differentiate with respect to.}

\item{eval.points}{Regressor points to be evaluated.  Set to \code{eval.points="median"} to find partial derivatives at the median of every variable.  Set to \code{eval.points="last"} to find partial derivatives at the last value of every variable.}

\item{order}{NNS.reg order, defaults to 1 for multivariate regressions.  If error, make sure \code{order=1}.}

\item{s.t.n}{Signal to noise parameter, sets the threshold of \code{NNS.dep} which reduces \code{"order"} when \code{order=NULL}.  Defaults to 0.9 to ensure high dependence for higher \code{"order"} and endpoint determination.}

\item{h}{Percentage step used for finite step method.  Defaults to \code{h=.1} representing a 10 percent step from the value of the regressor.}

\item{n.best}{Sets the number of closest regression points to use in kernel weighting.  Defaults to 2.}

\item{mixed}{If mixed derivative is to be evaluated, set \code{mixed=TRUE}.  Defaults to FALSE.}

\item{plot}{Set to \code{plot=TRUE} to view plot, defaults to FALSE.}

\item{precision}{Sets the number of regression points for estimates.  Set to \code{"HIGH"} where the limit condition of every observation as a regression point. Defaults to \code{"LOW"}.}

\item{norm}{Normalizes regressors between 0 and 1 for multivariate regression when set to \code{norm="std"}, or normalizes regressors according to \link{NNS.norm} when set to \code{norm="NNS"}. Defaults to NULL.}

\item{noise.reduction}{In low signal:noise situations, \code{noise.reduction="median"} uses medians instead of means for partitions, while \code{noise.reduction="mode"} (Default setting) uses modes instead of means for partitions.  \code{noise.reduction=NULL} allows for maximum possible fit.}
}
\value{
Returns the 1st derivative \code{"First Derivative"}, 2nd derivative \code{"Second Derivative"}, and mixed derivative \code{"Mixed Derivative"} (for two independent variables only).
}
\description{
Returns the numerical partial derivate of y with respect to [wrt] any regressor for a point of interest.  Finite difference method is used with \link{NNS.reg} estimates as f(x+h) and f(x-h) values.
}
\examples{
set.seed(123);x_1<-runif(100);x_2<-runif(100); y<-x_1^2*x_2^2
B=cbind(x_1,x_2)
## To find derivatives of y wrt 1st regressor
dy.d_(B,y,wrt=1,eval.points=c(.5,.5))
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{derivative,}
\keyword{nonlinear}
\keyword{partial}
\keyword{regression}

