% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nonlinear_FWL.R
\name{NNS.FWL}
\alias{NNS.FWL}
\title{Nonlinear FWL}
\usage{
NNS.FWL(B, y, order = 1, type = NULL, linear.test = FALSE)
}
\arguments{
\item{B}{Complete dataset of independent variables (IV) in matrix form.}

\item{y}{Dependent variable (DV).}

\item{order}{Controls the number of the \code{VN.reg}.  Defaults to \code{order=1}.}

\item{type}{Controls the partitioning in \code{VN.reg}.  Set to \code{type="XONLY"} for IV based partitioning.  Defaults to NULL for both IV and DV partitioning.}

\item{linear.test}{Set to \code{linear.test=TRUE} to run linear regression on residuals and compare to multiple linear regression output.}
}
\description{
Applies \code{VN.reg} to residuals per FWL (Frisch-Waugh-Lovell) Theorem for multiple nonlinear regression coefficients.
}
\examples{
set.seed(123);size=30;x_1=rnorm(size,mean=5,sd=1);x_2=rnorm(size,mean=1,sd=5); x_3=runif(size)
y=x_1^2+x_2+x_3
B=cbind(x_1,x_2,x_3)
NNS.FWL(B,y)

## Test the coefficients
set.seed(123);size=30;x_1=rnorm(size,mean=5,sd=1);x_2=rnorm(size,mean=1,sd=5); x_3=runif(size)
y=x_1^2+x_2+x_3
B=cbind(x_1,x_2,x_3)
NNS.FWL(B,y,linear.test=TRUE)
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{Frisch-Waugh-Lovell,}
\keyword{multiple}
\keyword{nonlinear}
\keyword{regression}

