##' Read simulation results based on NMsim's track of model runs
##' @param x Path to the simulation-specific rds file generated by
##'     NMsim, typically called `NMsim_paths.rds`. Or a table of
##'     simulation runs as returned by NMsim when `wait=FALSE`.
##' @param as.fun The default is to return data as a data.frame. Pass
##'     a function (say tibble::as_tibble) in as.fun to convert to
##'     something else. If data.tables are wanted, use
##'     as.fun="data.table". The default can be configured using
##'     NMdataConf.
##' @return A data set of class defined by as.fun
##' @import NMdata
##' @import fst
##' @export

NMreadSim <- function(x,as.fun){

    . <- NULL
    ROWMODEL2 <- NULL
    args.NMscanData <- NULL
    path.sim.lst <- NULL

    file.res.data <- NULL

    if(missing(as.fun)) as.fun <- NULL
    as.fun <- NMdata:::NMdataDecideOption("as.fun",as.fun)

    ## when to look for combined and saved results?
    


    ## if path is a dir, search for rds
    
    ## if an rds, just read it
    if(!is.list(x) && is.character(x)) {
        tab.paths <- readRDS(x)
        
        if(!inherits(tab.paths,"NMsimTab")) {
            stop("The provided rds file does not contain a NMsimTab object")
        }
        file.res.data <- fnAppend(fnExtension(x,"fst"),"res")
    } else if(is.NMsimTab(x)){
        tab.paths <- x
    }
    
    ## if an lst, read it
    if(!is.null(file.res.data) &&
       file.exists(file.res.data) &&
       file.mtime(file.res.data)>file.mtime(x)){
        res <- read_fst(file.res.data,as.data.table=TRUE)
    } else {
        
### read all sim results
        if(F){
            ## this simple approach may fail if the models return incompatible columns
            res <- tab.paths[,{
                cat(ROWMODEL2," ")
                ## the rds table must keep NMscanData arguments
                args.NM <- args.NMscanData[[1]]
                if(! "quiet" %in% names(args.NM)){
                    args.NM$quiet <- TRUE
                }
                
                do.call(NMscanData,c(list(file=path.sim.lst),args.NM))
            },keyby=.(ROWMODEL2)]
        }

####  must read each model into list elements. Then rbind(fill=T)
### this is to make sure results from different models with
### incompatible columns can be combined.

        res.list <- lapply(split(tab.paths,by="ROWMODEL2"),function(dat){
            dat[,{
                ## cat(ROWMODEL2," ")     
                ## the rds table must keep NMscanData arguments
                args.NM <- args.NMscanData[[1]]
                if(! "quiet" %in% names(args.NM)){
                    args.NM$quiet <- TRUE
                }
                
                do.call(NMscanData,c(list(file=path.sim.lst),args.NM))
            },by=.(ROWMODEL2)]
        })
        res <- rbindlist(res.list,fill=TRUE)
        res[,ROWMODEL2:=NULL]

        if(!is.null(file.res.data)){
            NMwriteData(res,file=file.res.data,formats.write="fst",genText=F)
        }
    }

    setattr(res,"NMsim-models",tab.paths)
    return(as.fun(res))
}
