% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find-nonmem.R
\name{find_nonmem}
\alias{find_nonmem}
\alias{find_nm_install_path}
\alias{find_nm_tran_path}
\title{Find location of NONMEM installation}
\usage{
find_nm_install_path(name = "default")

find_nm_tran_path(name = "default", warn = TRUE)
}
\arguments{
\item{name}{Character name of NONMEM installation (according PsN).}

\item{warn}{Logical (default = \code{TRUE}) to warn if fails to find NMTRAN.exe.}
}
\value{
If functions cannot find installation they will return \code{NULL} without
errors or warning, otherwise they will return the located paths.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Attempts to find location of NONMEM installation directory used by PsN.  Can
be useful for finding the location of parafiles etc.
}
\details{
The function \code{find_nm_install_path()} will attempt to use a locally
available PsN installation to get this information.  If the PsN
installation is on a remote server, this function will not work (it will
return a \code{NULL})

The function \code{find_nm_tran_path()} will attempt to use a locally
available PsN installation to get this information.  If the PsN
installation is on a remote server, this function will not work (it will
return a \code{NULL}). This is normally used to set \code{\link[=nm_tran_command]{nm_tran_command()}}.  If
this function cannot find installation, you will need to set
\code{\link[=nm_tran_command]{nm_tran_command()}}, manually.
}
\seealso{
\code{\link[=nm_tran_command]{nm_tran_command()}}
}
