% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPC_DSM.R
\name{MPC_DSM}
\alias{MPC_DSM}
\title{MPC_DSM}
\usage{
MPC_DSM(specdat, withBC = TRUE)
}
\arguments{
\item{specdat}{A complex number vector of observed frequency domain data.}

\item{withBC}{A logical parameter that enables/disables baseline correction after baseline correction}
}
\value{
A numeric vector of phase corrected absorption spectrum
}
\description{
Multiple single linear models that minimize the total dispersion.
}
\details{
This function is used to process phase error correction through multiple single linear models that minimize the total dispersion, followed by polynomial baseline correction when necessary.
}
\examples{
data("fdat")
mpc_dsm_phased1 <- MPC_DSM(fdat$frequency_domain)
}
\references{
Binczyk, F., Tarnawski, R., & Polanska, J. (2015). Strategies for optimizing the phase correction algorithms in Nuclear Magnetic Resonance spectroscopy. Biomedical Engineering Online, 14 Suppl 2(Suppl 2), S5. https://doi.org/10.1186/1475-925X-14-S2-S5

Liland KH, Almøy T, Mevik B (2010), Optimal Choice of Baseline
Correction for Multivariate Calibration of Spectra, Applied Spectroscopy 64, pp. 1007-1016.
}
\author{
Aixiang Jiang
}
\concept{phase correction}
