% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engines_el_impl_dataframe.R
\name{el_dataframe}
\alias{el_dataframe}
\alias{el.data.frame}
\title{Empirical likelihood for data frames (NMAR)}
\usage{
\method{el}{data.frame}(
  data,
  formula,
  auxiliary_means = NULL,
  standardize = TRUE,
  trim_cap = Inf,
  control = list(),
  on_failure = c("return", "error"),
  variance_method = c("bootstrap", "none"),
  bootstrap_reps = 500,
  n_total = NULL,
  start = NULL,
  trace_level = 0,
  family = logit_family(),
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} where the outcome column contains \code{NA}
for nonrespondents.}

\item{formula}{Two-sided formula \code{Y_miss ~ auxiliaries} or
\code{Y_miss ~ auxiliaries | missingness_predictors}.}

\item{auxiliary_means}{Named numeric vector of population means for auxiliary
design columns. Names must match the materialized \code{model.matrix} columns on
the first RHS (after formula expansion), including factor indicators and
transformed terms. The intercept is always excluded.}

\item{standardize}{Logical; whether to standardize predictors prior to estimation.}

\item{trim_cap}{Numeric; cap for EL weights (\code{Inf} = no trimming).}

\item{control}{List; optional solver control parameters for
\code{nleqslv::nleqslv(control = ...)}.}

\item{on_failure}{Character; one of \code{"return"} or \code{"error"} on solver failure.}

\item{variance_method}{Character; one of \code{"bootstrap"} or \code{"none"}.}

\item{bootstrap_reps}{Integer; number of bootstrap reps if
\code{variance_method = "bootstrap"}.}

\item{n_total}{Optional analysis-scale population total \code{N_pop}. When the
outcome contains at least one \code{NA}, \code{n_total} defaults to
\code{nrow(data)}. When respondents-only data are supplied (no \code{NA} in
the outcome), \code{n_total} must be provided.}

\item{start}{Optional list of starting values passed to the solver helpers.}

\item{trace_level}{Integer 0-3 controlling estimator logging detail.}

\item{family}{Missingness (response) model family specification (defaults to the logit bundle).}

\item{...}{Additional arguments passed to the solver.}
}
\description{
Internal method dispatched by \code{el()} when \code{data} is a
  \code{data.frame}. Returns \code{c("nmar_result_el","nmar_result")} with the
  point estimate, optional
  bootstrap SE, weights, coefficients, diagnostics, and metadata.
}
\details{
Implements the empirical likelihood estimator for IID data with
  optional auxiliary moment constraints. The missingness-model score is the
  Bernoulli derivative with respect to the linear predictor, supporting logit
  and probit links. When respondents-only data are supplied (no \code{NA} in the
  outcome), \code{n_total} is required so the response-rate equation targets the
  full sample size. When missingness is observed (\code{NA} present), the default
  population total is \code{nrow(data)}. If respondents-only data are used and
  auxiliaries are requested, you must also provide population auxiliary
  means via \code{auxiliary_means}. Result weights are the unnormalized EL
  masses \eqn{a_i / D_i(\theta)} on the analysis scale, where \eqn{a_i \equiv 1}
  for IID data.
}
\keyword{internal}
