% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_gaussianfield.R
\name{nlm_gaussianfield}
\alias{nlm_gaussianfield}
\title{nlm_gaussianfield}
\usage{
nlm_gaussianfield(nCol, nRow, resolution = 1, autocorr_range = 10,
  mag_var = 0.025, beta = c(1, 0.01, 0.005), nug = 1,
  direction = "random", angle = 1, rescale = TRUE)
}
\arguments{
\item{nCol}{[\code{numerical(1)}]\cr
Number of columns for the raster.}

\item{nRow}{[\code{numerical(1)}]\cr
Number of rows for the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{autocorr_range}{[\code{numerical(1)}]\cr
Maximal distance of spatial autocorrelation}

\item{mag_var}{[\code{numerical(1)}]\cr
Magnitude of variation in the field}

\item{beta}{[\code{numerical(1)}]\cr
Mean value over the field.}

\item{nug}{[\code{numerical(1)}]\cr
Small-scale variations in the field.}

\item{direction}{[\code{character("random" | "linear")}]\cr
Direction of the gradient. Either random, or with a linear trend (default).}

\item{angle}{[\code{numerical(1)}]\cr
Maximal distance of spatial autocorrelation}

\item{rescale}{[\code{numeric(1)}]\cr
If \code{TRUE} (default), the values are rescaled between 0-1.}
}
\value{
RasterLayer
}
\description{
Simulate spatially correlated random fields (Gaussian random fields) model.
}
\examples{
nlm_gaussianfield(nCol = 100, nRow = 100, 5)

}
