% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_score.R
\name{calculate_z_score}
\alias{calculate_z_score}
\title{Calculate 'standard' Z-score}
\usage{
calculate_z_score(nipt_sample, nipt_control_group, chromo_focus)
}
\arguments{
\item{nipt_sample}{The NIPTSample object that is the focus of the analysis}

\item{nipt_control_group}{The NIPTControlGroup object used in the analysis}

\item{chromo_focus}{The chromosome of interest. Most commonly chromosome 13, 18 or 21. 
However, every autosomal chromosome can be predicted}
}
\value{
ZscoreResult object
}
\description{
Calculate 'standard' Z-score
}
\details{
In the Z-score approach, introduced by Chiu et al in 2008, 
the chromosomal fraction of interest of a sample is compared 
to the chromosomal fractions of interest of the reference samples, 
the `NIPTControlGroup` object.
The output of the function is an object of class `ZscoreResult`. It is a named list containing seven fields:
\itemize{
\item numeric \strong{sample_Zscore} The Z score for the sample of interest for the sample of interest
\item named num \strong{control_group_statistics} Named num of length 3, the first field being the 
mean (name mean), the second field is the standard deviation (name SD) 
and the third field is the P value of the Shapiro-Wilk test (name Shapiro_P_value)
\item matrix \strong{control_group_Zscores} containing the Z scores of the chromosome of interest for 
all used control samples
\item integer \strong{focus_chromosome} The chromosome of interest. Most commonly chromosome 13, 18 or 21.
However, every autosomal chromosome can be predicted
\item string \strong{control_group_sample_names} The sample names of all control group samples used in the
analysis
\item string \strong{correction_status} The correction status of the control group
\item string \strong{sample_name} The sample_name of the sample of interest
}
}
\examples{
\dontrun{
z_score_result_13 <- calculate_z_score(nipt_sample = sample_of_interest, 
                                       nipt_control_group = control_group, 
                                       chromo_focus = 13)
}

}

