% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_play.R
\name{sample_play}
\alias{sample_play}
\title{Sample one NFL play according to some strategy}
\usage{
sample_play(
  what_down,
  yards_to_go,
  yards_from_own_goal,
  window_yards_from_own_goal = 1,
  play_by_play_data,
  strategy = "normal",
  ...
)
}
\arguments{
\item{what_down}{The current down (1st, 2nd, 3rd, or 4th down)}

\item{yards_to_go}{Number of yards to go until a first down or TD}

\item{yards_from_own_goal}{The number of yards from the possession team's own goal}

\item{window_yards_from_own_goal}{Precision parameter for "yards_from_own_goal" (a value of 1 means the sampling
will occur within plus or minus 1 of the "yards_from_own_goal" value)}

\item{play_by_play_data}{A data file from nflscrapR prepped using the prep_pbp_data.R function}

\item{strategy}{A string describing the strategy to be used, default is "normal", others include: "fourth_downs" and "passes_rushes" 
which implement some strategy regarding 4th downs and proportion of plays that are passing plays, respectively.}

\item{...}{Additional arguments for different strategies}
}
\value{
A tibble containing lots of info
}
\description{
This function will return a sample play from the nflscrapR play-by-play
data for a given down, distance, yards from the team's goal, using the
usual NFL-coaching strategy.
}
\examples{
\dontrun{
sample_play_test(what_down = 3,
                 yards_to_go = 2,
                 yards_from_own_goal = 45,
                 play_by_play_data = pbp_data,
                 strategy = "normal")
}
}
