% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulations.R
\name{Futures.Price.Simulate}
\alias{Futures.Price.Simulate}
\title{Futures.Price.Simulate:}
\usage{
Futures.Price.Simulate(X.0, parameters, dt, N.obs, TTM, verbose = TRUE)
}
\arguments{
\item{X.0}{Initial values of the state vector.}

\item{parameters}{A named vector of parameter values of a specified N-factor model. Function \code{NFCP.Parameters} is recommended.}

\item{dt}{discrete time step of simulation}

\item{N.obs}{The number of observations to simulate}

\item{TTM}{A vector or matrix of the time to maturity of futures contracts to simulate. See \bold{details}}

\item{verbose}{\code{logical}. Should the simulated state variables and associated prices be output?}
}
\value{
\code{Futures.Price.Simulate} returns a list with three objects when \code{verbose = T} and a matrix of simulated futures prices when \code{verbose = F}. The list objects returned are:

\code{State.Vector} A \code{matrix} of Simulated state variables at each discrete time point. The columns represent each factor of the N-factor model and the rows represent
the simulated values at each discrete simulated time point.

\code{Futures} A \code{matrix} of Simulated futures prices, with each column representing a simulated futures contract.

\code{Spot} A vector of simulated spot prices
}
\description{
Simulate Futures price data with dynamics that follow the parameters of an N-factor model through Monte Carlo simulation.
}
\details{
\loadmathjax
The \code{Futures.Price.Simulate} function simulates futures price data using the Kalman Filter algorithm, drawing from a normal
distribution for the shocks in the transition and measurement equations at each discrete time step. At each discrete time point,
an observation of the state vector is generated through the transition equation, drawing from a normal distribution with a covariance equal to \mjeqn{Q_t}{Q[t]}.
Following this, simulated futures prices are generated through the measurement equation, drawing from a normal distribution with covariance matrix equal to \mjeqn{H}{H}.

Input \code{TTM} can be either a matrix specifying the constant time to maturity of futures contracts to simulate, or it can be a matrix where \code{nrow(TTM) == N.obs} for the time-varying time to maturity of the futures contracts to simulate. This allows for the simulation of both aggregate stitched data and individual futures contracts.
}
\examples{
##Example 1 - Simulate Crude Oil Stitched futures prices
##under a Two-Factor model, assuming a constant time to maturity:

Simulated.Stitched.Futures <- Futures.Price.Simulate(X.0 = c(log(SS.Oil$Spot[1,1]), 0),
                                                   parameters = SS.Oil$Two.Factor,
                                                   dt = SS.Oil$dt,
                                                   N.obs = nrow(SS.Oil$Stitched.Futures),
                                                   TTM = SS.Oil$Stitched.TTM)

##Example 2 - Simulate Crude Oil Contract Prices under a Two-Factor model

###Assume constant white noise in parameters of 1\%:
SS.Oil.Two.Factor <- SS.Oil$Two.Factor
SS.Oil.Two.Factor <- SS.Oil.Two.Factor[!grepl("contract", names(SS.Oil.Two.Factor))]
SS.Oil.Two.Factor["sigma.contracts"] <- 0.01

Simulated.Contracts <- Futures.Price.Simulate(X.0 = c(log(SS.Oil$Spot[1,1]), 0),
                                            parameters = SS.Oil.Two.Factor,
                                            dt = SS.Oil$dt,
                                            N.obs = nrow(SS.Oil$Contracts),
                                            TTM = SS.Oil$Contract.Maturities)

}
\references{
Schwartz, E. S., and J. E. Smith, (2000). Short-Term Variations and Long-Term Dynamics in Commodity Prices. \emph{Manage. Sci.}, 46, 893-911.

Cortazar, G., and L. Naranjo, (2006). An N-factor Gaussian model of oil futures prices. \emph{Journal of Futures Markets: Futures, Options, and Other Derivative Products}, 26(3), 243-268.
}
