% Generated by roxygen2 (4.0.1): do not edit by hand
\name{extend.pc}
\alias{extend.pc}
\title{Extend an interval by percentage}
\usage{
extend.pc(X, pc = 0.5, pos = TRUE, neg = TRUE, swap = FALSE)
}
\arguments{
\item{X}{a numeric range, should be length 2. If a longer numeric, will be coerced with range()}

\item{pc}{percentage by which to extend X, can be entered in either percentage style: 0<pc<1;
or 1<pc<100}

\item{swap}{logical, if TRUE, flip the extension directions if X[2]<X[1], ie, not in numerical
order}

\item{pos}{logical, if TRUE, make an extension in the positive direction}

\item{neg}{logical, if TRUE, make an extension in the negative direction}
}
\description{
For various reasons, such as applying windows, setting custom range limits for plots, it may
be desirable to extend an interval by a certain percentage.
}
\examples{
extend.pc(c(2,10),0.25) # extend X symmetrically
extend.pc(c(2:10),0.25) # extend the range of X
# the following 3 examples extend X by 1\% only in the 'positive' direction
extend.pc(c(25000,55000),.01,neg=FALSE) # standard positive extension
extend.pc(c(55000,25000),.01,neg=FALSE) # ranges in reverse order, not swapped
extend.pc(c(55000,25000),.01,neg=FALSE,swap=TRUE) # ranges in reverse order, swapped
}

