% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uscore.R
\name{uscore}
\alias{uscore}
\title{U-score (individual value)}
\usage{
uscore(y, ind, rnk = TRUE)
}
\arguments{
\item{y}{The column of data values plus detection limits}

\item{ind}{The column of indicators, where 1 (or \code{TRUE}) indicates a detection limit in the \code{y} column, and 0 (or \code{FALSE}) indicates a detected value in \code{y}.}

\item{rnk}{A \code{TRUE}/\code{FALSE} variable on whether to compute the multivariate pattern on the uscores, or the ranks of the uscores.  Default is rnk=\code{TRUE}, use the ranks. rnk = \code{FALSE} returns the uscores.}
}
\value{
prints the uscore number of observations known to be lower - number of observations known to be higher, for each observation.
}
\description{
Computes the uscore of data (required 2-columns) with one or more detection limits.
}
\examples{
data(Brumbaugh)
uscore(Brumbaugh$Hg,Brumbaugh$HgCen)
}
