/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.client.async;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.parallel.ExecutorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncRecommenderUpdater
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(AsyncRecommenderUpdater.class);
    private final MyrrixRecommender delegate;
    private final ExecutorService executor;

    public AsyncRecommenderUpdater(MyrrixRecommender delegate) {
        Preconditions.checkNotNull(delegate);
        this.delegate = delegate;
        this.executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("AsyncRecommenderUpdater-%s").build());
    }

    public void ingest(final Reader reader) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncRecommenderUpdater.this.delegate.ingest(reader);
                }
                catch (Exception e) {
                    log.warn("Unexpected error in async update", e);
                }
            }
        });
    }

    public void ingest(final File file) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncRecommenderUpdater.this.delegate.ingest(file);
                }
                catch (Exception e) {
                    log.warn("Unexpected error in async update", e);
                }
            }
        });
    }

    public void setPreference(final long userID, final long itemID) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncRecommenderUpdater.this.delegate.setPreference(userID, itemID);
                }
                catch (Exception e) {
                    log.warn("Unexpected error in async update", e);
                }
            }
        });
    }

    public void setPreference(final long userID, final long itemID, final float value) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncRecommenderUpdater.this.delegate.setPreference(userID, itemID, value);
                }
                catch (Exception e) {
                    log.warn("Unexpected error in async update", e);
                }
            }
        });
    }

    public void removePreference(final long userID, final long itemID) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncRecommenderUpdater.this.delegate.removePreference(userID, itemID);
                }
                catch (Exception e) {
                    log.warn("Unexpected error in async update", e);
                }
            }
        });
    }

    public void refresh() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncRecommenderUpdater.this.delegate.refresh();
                }
                catch (Exception e) {
                    log.warn("Unexpected error in async update", e);
                }
            }
        });
    }

    @Override
    public void close() {
        ExecutorUtils.shutdownNowAndAwait(this.executor);
    }
}

