% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADF_FL.R
\name{ADF_FL}
\alias{ADF_FL}
\title{Augmented Dickey-Fuller Statistic}
\usage{
ADF_FL(y, adflag = 0, mflag = 1)
}
\arguments{
\item{y}{the time series to be used.}

\item{adflag}{is the lag order.}

\item{mflag}{1 for ADF with constant and whithout trend, 2 for ADF with constant and trend and 3 for ADF without constant and trend.}
}
\description{
Calculate the Augmented Dickey-Fuller Statistic with a fixed lag order .
}
\examples{
y <- rnorm(10)
ADF_FL(y, adflag = 1, mflag = 2)
}
\references{
Phillips, P.C. & Shi, S. & Yu, J. (2015a). "Testing for Multiple Bubbles: Historical Episodes of Exuberance and Collapse in the S&P 500". \emph{SSRN Electronic Journal}.
}
\keyword{AugmentedDickey-FullerTest.}
