% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_functions.R
\name{filter_at_tp_min}
\alias{filter_at_tp_min}
\title{Filters a matrix of readouts for IS that have a minimum occurrence in some
measurement}
\usage{
filter_at_tp_min(data, at = "168", min = 0.02)
}
\arguments{
\item{data}{The readout matrix to filter.}

\item{at}{A filter for the columns/measurements. Only matching
columns/measurements are considered, though all will be returned.
This is a regular expression, so multiple columns/measurements may
match it.}

\item{min}{The minimum with which an IS has to occur. This could be either
absolute or relative reads. If `at` matches multiple
columns/measurements, the 'rowSum()' over the columns will be
used.}
}
\value{
A matrix with only the IS that occur with a minimum at the
        selected measurements.
}
\description{
Filters a matrix of readouts for IS that have a minimum occurrence in some
measurement
}
