% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{bushmanplot}
\alias{bushmanplot}
\title{Create a stacked area plot that represents the abundance of integration
sites over time.}
\usage{
bushmanplot(
  readouts,
  aes = NULL,
  col = NULL,
  only = NULL,
  rec = NULL,
  time = NULL,
  facet = NULL
)
}
\arguments{
\item{readouts}{The readouts of the integration sites over time.}

\item{aes}{An additional `ggplot2::aes` object, that will be used as the
plots main aesthetic. Note, that the `geom_area` object
overwrites some of these aesthetics. Useful if you later on
want to add additional elements to the plot.}

\item{col}{A color palette for integration sites that should be colored. Any
integration site not in this named vector will be colored
`gray50`. This takes precedence over `only` and `rec`.}

\item{only}{A list of integration sites that should be colored with the
default ggplot2 color palette. Any other integration site is
colored `gray50`. Takes precedence over `rec`.}

\item{rec}{A matrix containing the columns "IS" and "Clone". Integration
sites will be colored by the clone they belong to. The colors for
the clones are the default ggplot2 ones.}

\item{time}{A function that extracts the time component from the measurement
(i.e. column)-names. Will be applied to the measurements.}

\item{facet}{A function that extracts a value from the measurement names and
splits the plot into different facets by that values. Useful,
for example if you have measurements that are sorted for the
cell type and you want to split these into facets.}
}
\description{
Create a stacked area plot that represents the abundance of integration
sites over time.
}
