% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeQxDataFrame.R
\name{makeQxDataFrame}
\alias{makeQxDataFrame}
\title{Converts one or multiple mortality table objects to a data frame that can be
plotted by \code{plotMortalityTables} or \code{plotMortalityTableComparisons}}
\usage{
makeQxDataFrame(..., YOB = 1972, Period = NA, reference = NULL)
}
\arguments{
\item{...}{Life tables (objects of classes derived from \code{mortalityTable})}

\item{YOB}{desired year of birth to be plotted as cohort life table (default: 1972)}

\item{Period}{desired observation year to be plotted (default: NA). If both
\code{YOB} and \code{Period} are given, a period comparison is generated.}

\item{reference}{Reference life table, used to show relative death
probabilities (i.e. the q_x for all ages are divided by the
corresponding probabilities of the reference table)}
}
\description{
It is not required to call this function manually, \code{plotMortalityTables}
will automatically do it if object derived from class \code{mortalityTable}
are passed.
}
\examples{
mortalityTables.load("Austria_Annuities")
makeQxDataFrame(AVOe2005R.male, AVOe2005R.female, YOB = 1975)

}
