% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertFx.R
\name{convertFx}
\alias{convertFx}
\title{Convert Life Table Indicators}
\usage{
convertFx(x, data, from, to, ...)
}
\arguments{
\item{x}{Vector of ages at the beginning of the age interval.}

\item{data}{Vector or data.frame/matrix containing the mortality indicators.}

\item{from}{Specify the life table indicator in the input \code{data}.
Character. Options: \code{mx, qx, dx, lx}.}

\item{to}{What indicator would you like to obtain? Character.
Options: \code{mx, qx, dx, lx, Lx, Tx, ex}.}

\item{...}{Further arguments to be passed to the \code{\link{LifeTable}}
function with impact on the results to be produced.}
}
\value{
A matrix or array containing life table indicators.
}
\description{
Easy conversion between the life table indicators. This function is based
on the \code{\link{LifeTable}} function and methods behind it.
}
\examples{
# Data ---
x  <- 0:110
mx <- ahmd$mx

# mx to qx
qx <- convertFx(x, data = mx, from = "mx", to = "qx")
# mx to dx
dx <- convertFx(x, data = mx, from = "mx", to = "dx")
# mx to lx
lx <- convertFx(x, data = mx, from = "mx", to = "lx")


# There are 28 possible combinations --------------------------------
# Let generate all of them.
from <- c("mx", "qx", "dx", "lx")
to   <- c("mx", "qx", "dx", "lx", "Lx", "Tx", "ex")
K    <- expand.grid(from = from, to = to) # all possible cases/combinations

for (i in 1:nrow(K)) {
  In  <- as.character(K[i, "from"])
  Out <- as.character(K[i, "to"])
  N <- paste0(Out, "_from_", In)
  cat(i, " Create", N, "\n")
  # Create the 28 sets of results
  assign(N, convertFx(x = x, data = get(In), from = In, to = Out))
}
}
\seealso{
\code{\link{LifeTable}}
}
\author{
Marius D. Pascariu
}
