% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kannisto.R
\name{cokannisto.estimate}
\alias{cokannisto.estimate}
\title{Coherent Kannisto Estimation}
\usage{
cokannisto.estimate(mxM, mxF, ages)
}
\arguments{
\item{mxM}{A vector of male mortality rates.}

\item{mxF}{A vector of female mortality rates.}

\item{ages}{A vector of ages corresponding to \code{mxM} and \code{mxF}.}
}
\value{
List of two lists, one for male and one for female. Each of the two lists contains the following components:
\describe{
   \item{\code{coefficients}:}{named vector with the coherent Kannisto coefficients \eqn{c} and \eqn{d}. The \eqn{d} values are the same in both lists.}
   \item{\code{fitted.values}:}{the fitted values}
   \item{\code{residuals}:}{input rates minus the fitted values}
}
}
\description{
Estimate the coherent Kannisto parameters as described in Sevcikova et al. (2016).
}
\details{
Given the Kannisto equation \eqn{mlogit(m_x) = \log(c) + dx}{mlogit(mx) = log(c) + dx},
    the Coherent Kannisto method estimates the \eqn{d} parameter jointly for male and female 
    data, in order to prevent mortality crossovers in higher ages.
}
\examples{
data(mxM, mxF, package = "wpp2017")
country <- "Brazil"
mxm <- subset(mxM, name == country)[,"2010-2015"]
mxf <- subset(mxF, name == country)[,"2010-2015"]
cokannisto.estimate(mxm[18:21], mxf[18:21], ages = 18:21)

}
\references{
Sevcikova H., Li N., Kantorova V., Gerland P., Raftery A.E. (2016). 
Age-Specific Mortality and Fertility Rates for Probabilistic Population Projections. 
In: Schoen R. (eds) Dynamic Demographic Analysis. The Springer Series on Demographic Methods
and Population Analysis, vol 39. Springer, Cham
}
\seealso{
\code{\link{cokannisto}}, \code{\link{kannisto.predict}}, \code{\link{kannisto}}
}
