% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-out-sfourier.R
\name{sfourier_shape}
\alias{sfourier_shape}
\title{Calculates and draw 'sfourier' shapes.}
\usage{
sfourier_shape(an, bn, nb.h, nb.pts = 80, alpha = 2, plot = TRUE)
}
\arguments{
\item{an}{\code{numeric}. The \eqn{a_n} Fourier coefficients on which to
calculate a shape.}

\item{bn}{\code{numeric}. The \eqn{b_n} Fourier coefficients on which to
calculate a shape.}

\item{nb.h}{\code{integer}. The number of harmonics to use.}

\item{nb.pts}{\code{integer}. The number of points to calculate.}

\item{alpha}{\code{numeric}. The power coefficient associated with the
(usually decreasing) amplitude of the Fourier coefficients (see
\bold{Details}).}

\item{plot}{\code{logical}. Whether to plot or not the shape.}
}
\value{
A matrix of (x; y) coordinates.
}
\description{
\code{sfourier_shape} calculates a 'Fourier radii variation shape' given
Fourier coefficients (see \code{Details}) or can generate some 'sfourier'
shapes.
}
\details{
\code{sfourier_shape} can be used by specifying \code{nb.h} and
\code{alpha}. The coefficients are then sampled in an uniform distribution
\eqn{(-\pi ; \pi)} and this amplitude is then divided by
\eqn{harmonicrank^alpha}. If \code{alpha} is lower than 1, consecutive
coefficients will thus increase. See \link{sfourier} for the mathematical
background.
}
\examples{
rf <- sfourier(bot[1], 24)
sfourier_shape(rf$an, rf$bn) # equivalent to sfourier_i(rf)
sfourier_shape() # not very interesting

sfourier_shape(nb.h=12) # better
sfourier_shape(nb.h=6, alpha=0.4, nb.pts=500)

# Butterflies of the vignette' cover
panel(Out(a2l(replicate(100,
sfourier_shape(nb.h=6, alpha=0.4, nb.pts=200, plot=FALSE)))))
}
\references{
Renaud S, Pale JRM, Michaux JR (2003): Adaptive latitudinal trends in the mandible shape
of \emph{Apodemus} wood mice. \emph{J Biogeogr} 30:1617-1628.
}
\seealso{
Other sfourier: \code{\link{sfourier_i}},
  \code{\link{sfourier}}
}
