% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-shapedescriptors.R
\name{coo_tangle}
\alias{coo_tangle}
\title{Calculates the tangent angle along the perimeter of a shape}
\usage{
coo_tangle(coo)
}
\arguments{
\item{coo}{a matrix of coordinates}
}
\value{
a numeric, the tangent angle along the perimeter
}
\description{
Calculated using complex numbers and returned in radians
minus the first one (modulo 2*pi).
}
\examples{
data(bot)
b <- bot[1]
phi  <- coo_tangle(b)
phi2 <- coo_tangle(coo_smooth(b, 2))
plot(phi, type='l')
plot(phi2, type='l', col='red') # ta is very sensible to noise
}
\seealso{
\link{tfourier}

Other coo_ descriptors: \code{\link{coo_area}},
  \code{\link{coo_boundingbox}}, \code{\link{coo_chull}},
  \code{\link{coo_circularityharalick}},
  \code{\link{coo_circularitynorm}},
  \code{\link{coo_circularity}},
  \code{\link{coo_convexity}},
  \code{\link{coo_eccentricityboundingbox}},
  \code{\link{coo_eccentricityeigen}},
  \code{\link{coo_elongation}}, \code{\link{coo_length}},
  \code{\link{coo_lw}}, \code{\link{coo_rectangularity}},
  \code{\link{coo_rectilinearity}},
  \code{\link{coo_solidity}}, \code{\link{coo_theta3}},
  \code{\link{coo_thetapts}}, \code{\link{coo_width}}
}

