% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{perm.cor.mtest}
\alias{perm.cor.mtest}
\title{Test par permutation d'une matrice de corrélations de Bravais-Pearson}
\usage{
perm.cor.mtest(mat, alternative = "two.sided", method = "pearson",
  num.sim = 20000, ...)
}
\arguments{
\item{mat}{Matrice des données}

\item{alternative}{Type d'hypothèses bilatéral, unilatéral inférieur ou supérieur}

\item{method}{Méthode de calcul de corrélation Pearson ou Spearman}

\item{num.sim}{Nombre de simulations}

\item{...}{Paramètre suplémentaires transmis à la fonction cor}
}
\value{
Liste de deux éléments : matrice p.mat (matrice des p-valeurs des tests) et matrice cor.mat (matrice des valeurs observées des coefficients de corrélation de Bravais-Pearson)
}
\description{
Test par permutation d'une matrice de corrélations de Bravais-Pearson
}
\examples{
data(Mesures5,package="BioStatR")
Mes5_red_gv = subset(Mesures5[,-5],subset=Mesures5$espece=="glycine violette")
perm.cor.mtest(Mes5_red_gv,num.sim=100)

}
