% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mte.R
\name{coef.mte}
\alias{coef.mte}
\alias{coeffMTE}
\alias{coeffExp}
\title{Extract MTE Coefficients}
\usage{
coeffMTE(fx)

coeffExp(fx)
}
\arguments{
\item{fx}{An \code{"motbf"} function of subclass \code{'mop'}.}
}
\value{
An array with the parameters of the function.
}
\description{
It extracts the parameters of the learned mixtures of truncated exponential models.
}
\details{
\code{coeffMOP()} return the coefficients of the terms in the function.

\code{coeffPol()} returns the coefficients of the potential of the polynomial basis in the function.
}
\examples{

## 1. EXAMPLE
data <- rnorm(1000, mean=5)
fx1 <- univMoTBF(data, POTENTIAL_TYPE = "MTE")
hist(data, prob=TRUE, main="")
plot(fx1, xlim=range(data), col="red", add=TRUE)
coeffMTE(fx1) ## coef(fx1)
coeffExp(fx1)

## 2. EXAMPLE
data <- rexp(1000, rate=1/2)
fx2 <- univMoTBF(data, POTENTIAL_TYPE = "MTE")
hist(data, prob=TRUE, main="")
plot(fx2, xlim=range(data), col="red", add=TRUE)
coeffMTE(fx2) ## coef(fx2)
coeffExp(fx2)
 
}
\seealso{
\link{coef.motbf} and \link{univMoTBF}
}
